/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.registry;

import com.ninni.spawn.block.AntMoundBlock;
import com.ninni.spawn.block.AnthillBlock;
import com.ninni.spawn.block.BigSnailShellBlock;
import com.ninni.spawn.block.FallenLeavesBlock;
import com.ninni.spawn.block.GhostlyMucusBlockBlock;
import com.ninni.spawn.block.MucusBlock;
import com.ninni.spawn.block.MucusBlockBlock;
import com.ninni.spawn.block.PottedSweetBerryBushBlock;
import com.ninni.spawn.block.SnailEggsBlock;
import com.ninni.spawn.block.StrippablePlankBlock;
import com.ninni.spawn.block.SunflowerBlock;
import com.ninni.spawn.block.SunflowerPlantBlock;
import com.ninni.spawn.registry.SpawnBlockSetType;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnWoodType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="spawn", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpawnBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"spawn");
    public static final RegistryObject<Block> SNAIL_EGGS = SpawnBlocks.register("snail_eggs", () -> new SnailEggsBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_60910_().m_60978_(0.2f).m_60918_(SoundType.f_222466_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> BIG_SNAIL_SHELL = SpawnBlocks.register("big_snail_shell", () -> new BigSnailShellBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60913_(1.5f, 1200.0f).m_60918_(SpawnSoundEvents.SNAIL_SHELL)));
    public static final RegistryObject<Block> SNAIL_SHELL_TILES = SpawnBlocks.register("snail_shell_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BIG_SNAIL_SHELL.get())).m_60913_(1.0f, 1200.0f)));
    public static final RegistryObject<Block> SNAIL_SHELL_TILE_STAIRS = SpawnBlocks.register("snail_shell_tile_stairs", () -> new StairBlock(((Block)SNAIL_SHELL_TILES.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SNAIL_SHELL_TILES.get()))));
    public static final RegistryObject<Block> SNAIL_SHELL_TILE_SLAB = SpawnBlocks.register("snail_shell_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SNAIL_SHELL_TILES.get()))));
    public static final RegistryObject<Block> POTTED_SWEET_BERRY_BUSH = SpawnBlocks.register("potted_sweet_berry_bush", () -> new PottedSweetBerryBushBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60913_(1.5f, 1200.0f).m_60918_(SpawnSoundEvents.SNAIL_SHELL)));
    public static final RegistryObject<Block> MUCUS = SpawnBlocks.register("mucus", () -> new MucusBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283843_).m_60918_(SpawnSoundEvents.MUCUS).m_60955_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> MUCUS_BLOCK = SpawnBlocks.register("mucus_block", () -> new MucusBlockBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MUCUS.get()))));
    public static final RegistryObject<Block> GHOSTLY_MUCUS_BLOCK = SpawnBlocks.register("ghostly_mucus_block", () -> new GhostlyMucusBlockBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MUCUS.get()))));
    public static final RegistryObject<Block> SUNFLOWER = SpawnBlocks.register("sunflower", () -> new SunflowerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50355_).m_60977_()));
    public static final RegistryObject<Block> SUNFLOWER_PLANT = SpawnBlocks.register("sunflower_plant", () -> new SunflowerPlantBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> ANT_MOUND = SpawnBlocks.register("ant_mound", () -> new AntMoundBlock(Blocks.f_50546_, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(0.25f).m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_276658_), SoundEvents.f_276592_, SoundEvents.f_276508_));
    public static final RegistryObject<Block> ANTHILL = SpawnBlocks.register("anthill", () -> new AnthillBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(0.5f).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<Block> ROTTEN_LOG_ANTHILL = SpawnBlocks.register("rotten_log_anthill", () -> new AnthillBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283819_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SpawnSoundEvents.ROTTEN_WOOD).m_278183_().m_60978_(1.6f)));
    public static final RegistryObject<Block> ANT_FARM = SpawnBlocks.register("ant_farm", () -> new AnthillBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283824_).m_60955_().m_60978_(2.0f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> ROTTEN_LOG = SpawnBlocks.register("rotten_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60918_(SpawnSoundEvents.ROTTEN_WOOD)));
    public static final RegistryObject<Block> ROTTEN_WOOD = SpawnBlocks.register("rotten_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60918_(SpawnSoundEvents.ROTTEN_WOOD)));
    public static final RegistryObject<Block> STRIPPED_ROTTEN_LOG = SpawnBlocks.register("stripped_rotten_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_).m_60978_(0.8f).m_278166_(PushReaction.DESTROY).m_60918_(SpawnSoundEvents.ROTTEN_WOOD)));
    public static final RegistryObject<Block> STRIPPED_ROTTEN_WOOD = SpawnBlocks.register("stripped_rotten_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_).m_60978_(0.8f).m_278166_(PushReaction.DESTROY).m_60918_(SpawnSoundEvents.ROTTEN_WOOD)));
    public static final RegistryObject<Block> CRACKED_ROTTEN_PLANKS = SpawnBlocks.register("cracked_rotten_planks", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60913_(0.8f, 0.0f).m_60918_(SoundType.f_56736_).m_60918_(SpawnSoundEvents.CRACKED_ROTTEN_WOOD).m_278183_()));
    public static final RegistryObject<Block> ROTTEN_PLANKS = SpawnBlocks.register("rotten_planks", () -> new StrippablePlankBlock(((Block)CRACKED_ROTTEN_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60913_(1.0f, 1.0f).m_60918_(SpawnSoundEvents.ROTTEN_WOOD).m_278183_()));
    public static final RegistryObject<Block> ROTTEN_STAIRS = SpawnBlocks.register("rotten_stairs", () -> new StairBlock(((Block)ROTTEN_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROTTEN_PLANKS.get()))));
    public static final RegistryObject<Block> ROTTEN_SLAB = SpawnBlocks.register("rotten_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROTTEN_PLANKS.get()))));
    public static final RegistryObject<Block> ROTTEN_FENCE = SpawnBlocks.register("rotten_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROTTEN_PLANKS.get())).m_280606_()));
    public static final RegistryObject<Block> ROTTEN_FENCE_GATE = SpawnBlocks.register("rotten_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROTTEN_PLANKS.get())).m_280606_(), SpawnWoodType.ROTTEN));
    public static final RegistryObject<Block> ROTTEN_DOOR = SpawnBlocks.register("rotten_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROTTEN_PLANKS.get())).m_60955_(), SpawnBlockSetType.ROTTEN));
    public static final RegistryObject<Block> ROTTEN_TRAPDOOR = SpawnBlocks.register("rotten_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROTTEN_PLANKS.get())).m_60955_().m_60922_(SpawnBlocks::never), SpawnBlockSetType.ROTTEN));
    public static final RegistryObject<Block> FALLEN_LEAVES = SpawnBlocks.register("fallen_leaves", () -> new FallenLeavesBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SpawnSoundEvents.FALLEN_LEAVES).m_60966_().m_278183_().m_278166_(PushReaction.DESTROY).m_284268_(DyeColor.BROWN).m_60910_()));

    private static <B extends Block> RegistryObject<B> register(String id, Supplier<? extends B> block) {
        return BLOCKS.register(id, block);
    }

    private static Boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, EntityType<?> entityType) {
        return false;
    }
}

